uniform sampler2D texColor <
	string type = "input";
>;
uniform sampler2D texTarget <
	string type = "output";
>;

// --------------------------------------------------------- \\

struct VS_INPUT
{
	vec4 pos;
	vec2 tex;
};
struct VS_OUTPUT
{
	vec4 pos;
	vec2 tex;
};

// --------------------------------------------------------- \\

void PostProcess_VS(in VS_INPUT IN : 1, out VS_OUTPUT OUT)
{
	gl_Position = IN.pos;

	OUT.pos = IN.pos;
	OUT.tex = IN.tex;
}
void PostProcess_PS_Target(in VS_OUTPUT OUT, out vec4 FragColor0 : 0)
{
	// 0 --> Rendertarget 1
	// 1 --> Rendertarget 2
	// ...
	
	FragColor0 = texture2D(texColor, OUT.tex) * vec4(OUT.tex, 1.0, 1.0);
}
void PostProcess_PS(in VS_OUTPUT OUT, out vec4 FragColor)
{
	vec4 color = texture2D(texTarget, OUT.tex);
	color.a = 1.0f;

	FragColor = color;
}

// --------------------------------------------------------- \\

technique PostProcess
{
	pass p0 < string output0 = "texTarget"; >
	{
		VertexShader = compile 420 PostProcess_VS();
		FragmentShader = compile 420 PostProcess_PS_Target();
	}
	pass p1
	{
		VertexShader = compile 420 PostProcess_VS();
		FragmentShader = compile 420 PostProcess_PS();
	}
}
